package nl.umcg.deelenp.annotateintersectionoverview.annotations.properties;

import java.util.TreeMap;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;

/**
 *
 * @author PatrickDeelen
 */
public class PropertyFinder {

    private TreeMap<String, TreeMap<Integer, AnnotationProperty[]>> snps;

    public PropertyFinder() {
        snps = new TreeMap<String, TreeMap<Integer, AnnotationProperty[]>>();
    }

    public void add(String chromosome, Integer position, AnnotationProperty[] annotations){

        TreeMap<Integer, AnnotationProperty[]> chromosomeSnps;
        if(snps.containsKey(chromosome)){
            chromosomeSnps = snps.get(chromosome);
        } else {
            chromosomeSnps = new TreeMap<Integer, AnnotationProperty[]>();
            snps.put(chromosome, chromosomeSnps);
        }
        chromosomeSnps.put(position, annotations);

    }

    public AnnotationProperty[] get(String chromosome, Integer position){

        if(snps.containsKey(chromosome)){

            TreeMap<Integer, AnnotationProperty[]> chromosomeSnps = snps.get(chromosome);

            if(chromosomeSnps.containsKey(position)){
                return chromosomeSnps.get(position);
            } else {
                return null;
            }

        } else {
            return null;
        }
        
    }

}
