package nl.umcg.deelenp.annotateintersectionoverview.annotations.sources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSourcePosition;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.DoubleProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.IntProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.PropertyFinder;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.StringProperty;

/**
 *
 * @author PatrickDeelen
 */
public class SeparetedTextAnnotations implements AnnotationSourcePosition {

    private PropertyFinder snpProperties;
    private String[] annotationHeaders;
    private int numberOfAnnotationProperties;

    /**
     * 
     * @param file
     * @param separator
     * @param header
     * @param columns
     * @param chromosomeColumn
     * @param positionColumn
     * @throws FileNotFoundException
     * @throws IOException
     */
    public SeparetedTextAnnotations(String file, String separator, boolean header, ArrayList<AnnotationSourceColumn> columns, int chromosomeColumn, int positionColumn, boolean useFileHeadersIfPresent) throws FileNotFoundException, IOException {

        numberOfAnnotationProperties = columns.size();
        snpProperties = new PropertyFinder();

        Pattern separatorPattern = Pattern.compile(separator);

        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;

        annotationHeaders = new String[columns.size()];
        if(header){
            line = reader.readLine();
        }
        if(header && useFileHeadersIfPresent){
            String[] lineElements = separatorPattern.split(line);
            int i = 0;
            for(AnnotationSourceColumn column : columns){
                annotationHeaders[i] = lineElements[column.getColumn()];
                ++i;
            }
        } else {
            int i = 0;
            for(AnnotationSourceColumn column : columns){
                annotationHeaders[i] = column.getHead();
                ++i;
            }
        }

        while( (line = reader.readLine()) != null ){
            String[] lineElements = separatorPattern.split(line);
            String chromosome = lineElements[chromosomeColumn];
            int position = Integer.parseInt(lineElements[positionColumn]);
            
            AnnotationProperty[] annotations = new AnnotationProperty[columns.size()];
            int i = 0;
            for(AnnotationSourceColumn column : columns){
                String valueString = lineElements[column.getColumn()];
                switch(column.getType()){
                    case DOUBLE:
                        double doubleValue;
                        if(valueString.equals("NA")){
                            doubleValue = Double.NaN;
                        } else {
                            doubleValue = Double.valueOf(valueString);
                        }
                        
                        annotations[i] = new DoubleProperty(doubleValue);
                        break;
                    case INT:
                        int intValue = Integer.valueOf(valueString);
                        annotations[i] = new IntProperty(intValue);
                        break;
                    default:
                        annotations[i] = new StringProperty(valueString);

                }
                ++i;
            }

            snpProperties.add(chromosome, position, annotations);

        }

    }

    public String[] getAnnotationHeaders() {
        return annotationHeaders;
    }

    public AnnotationProperty[] getAnnotationForPosition(String chromosome, int position) {

        AnnotationProperty[] annotations = snpProperties.get(chromosome, position);
        if(annotations == null){
            return new AnnotationProperty[numberOfAnnotationProperties];
        } else {
            return annotations;
        }

    }

    public int getNumberOfAnnotationProperties() {
        return numberOfAnnotationProperties;
    }
    
}
