RNA=read.table('/virdir/Backup/run_1_gene_counts/combined_gene_count_run_1.txt',sep='\t',header=TRUE)
# save(RNA,file='/virdir/Backup/run_1_gene_counts/combined_gene_count_run_1_R_object')
# load('/virdir/Backup/run_1_gene_counts/combined_gene_count_run_1_R_object')

## get # zero counts per genes

ind=which(RNA==0,arr.ind = TRUE)
h=hist(ind[,1],breaks=0:dim(RNA)[1],plot=FALSE)
nz=h$counts # for each gene, # samples with zero counts

 length(which(nz==0))
[1] 3
 length(which(nz==1))
[1] 326
 length(which(nz==2))
[1] 15692

RNA_0=RNA[which(nz==2),]

## get IDs amsterdam sample

id=as.character(read.table('/home/rjansen/NTR_ID_mapping.txt',sep='\t')[,2])
m=match(id,colnames(RNA));length(which(is.na(m)))

RNA_0_A = RNA_0[,m]  # Amsterdam samples


## spearman  correlation

Cs=cor(RNA_0,method='spearman')
mCs= apply(Cs, 2, median,na.rm = TRUE)
mCsa=mCs[m] # Amsterdam
mCsna=mCs[setdiff(1:length(mCs),m)] # non Amsterdam

# Within a-dam:
Cs=cor(RNA_0_A,method='spearman')
mCsa_w = apply(Cs, 2, median)

t.test(mCsna,mCsa)
t.test(mCsna,mCsa_w)


png('Histogram_Mean_correlations_A-dam_non_A-dam_Spear_0_within')
hist(mCsa_w,30, col="blue",freq=FALSE,xlim=c(0.8,1),xlab='Spearman correlations, for Amsterdam computed only within Amsterdam ',main='')
hist(mCsna,300, col='#FF000080' ,add=TRUE,transparant=1,freq=FALSE)
legend('top',c('A-dam','Non A-dam'),bty='n',fill=c("blue",'#FF000080'))
dev.off()


png('Histogram_Mean_correlations_A-dam_non_A-dam_Spear_0')
hist(mCsa,30, col="blue",freq=FALSE,xlim=c(0.8,1),xlab='Spearman correlations',main='')
hist(mCsna,300, col='#FF000080' ,add=TRUE,transparant=1,freq=FALSE)
legend('top',c('A-dam','Non A-dam'),bty='n',fill=c("blue",'#FF000080'))
dev.off()
